﻿using System;
using System.Text;
using System.Collections.Generic;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using VeteransAffairs.Registries.BusinessAHOBPR;

namespace WCF_BusinessManagerAHOBPRTests
{
    /// <summary>
    /// Summary description for DateRangeTests
    /// </summary>
    [TestClass]
    public class DateRangeTests
    {
        public DateRangeTests()
        {
            //
            // TODO: Add constructor logic here
            //
        }

        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes
        //
        // You can use the following additional attributes as you write your tests:
        //
        // Use ClassInitialize to run code before running the first test in the class
        // [ClassInitialize()]
        // public static void MyClassInitialize(TestContext testContext) { }
        //
        // Use ClassCleanup to run code after all tests in a class have run
        // [ClassCleanup()]
        // public static void MyClassCleanup() { }
        //
        // Use TestInitialize to run code before running each test 
        // [TestInitialize()]
        // public void MyTestInitialize() { }
        //
        // Use TestCleanup to run code after each test has run
        // [TestCleanup()]
        // public void MyTestCleanup() { }
        //
        #endregion

        [TestMethod]
        public void Includes_Should_Be_True()
        {
            DateRange expectedToPass = new DateRange(DateTime.Parse("2007-01-09"), DateTime.Parse("2010-05-03"));
            DateRange cut = new DateRange(DateTime.Parse("2006-01-09"), DateTime.Parse("2012-05-03"));
            Assert.AreEqual(true, cut.Includes(expectedToPass));
        }

        [TestMethod]
        public void Includes_Should_Be_False_When_Both_Start_And_End_Are_Out_Of_Range()
        {
            DateRange expectedToPass = new DateRange(DateTime.Parse("2004-01-09"), DateTime.Parse("2013-05-03"));
            DateRange cut = new DateRange(DateTime.Parse("2006-01-09"), DateTime.Parse("2012-05-03"));
            Assert.AreEqual(false, cut.Includes(expectedToPass));
        }

        [TestMethod]
        public void Includes_Should_Be_False_When_Start_Is_Out_Of_Range()
        {
            DateRange expectedToPass = new DateRange(DateTime.Parse("2004-01-09"), DateTime.Parse("2011-05-03"));
            DateRange cut = new DateRange(DateTime.Parse("2006-01-09"), DateTime.Parse("2012-05-03"));
            Assert.AreEqual(false, cut.Includes(expectedToPass));
        }

        [TestMethod]
        public void Includes_Should_Be_False_When_End_Is_Out_Of_Range()
        {
            DateRange expectedToPass = new DateRange(DateTime.Parse("2007-01-09"), DateTime.Parse("2014-05-03"));
            DateRange cut = new DateRange(DateTime.Parse("2006-01-09"), DateTime.Parse("2012-05-03"));
            Assert.AreEqual(false, cut.Includes(expectedToPass));
        }
    }
}
